let blockedDomains = [];
let allowedDomains = [];
let detectionHistory = {};
let behaviorDetectionEnabled = true;

chrome.runtime.onInstalled.addListener(() => {
  chrome.storage.local.get(['blockedDomains', 'allowedDomains', 'detectionHistory', 'behaviorDetectionEnabled'], (result) => {
    blockedDomains = result.blockedDomains || [];
    allowedDomains = result.allowedDomains || [];
    detectionHistory = result.detectionHistory || {};
    behaviorDetectionEnabled = result.behaviorDetectionEnabled !== false;
  });
});

chrome.storage.local.get(['blockedDomains', 'allowedDomains', 'detectionHistory', 'behaviorDetectionEnabled'], (result) => {
  blockedDomains = result.blockedDomains || [];
  allowedDomains = result.allowedDomains || [];
  detectionHistory = result.detectionHistory || {};
  behaviorDetectionEnabled = result.behaviorDetectionEnabled !== false;
});

chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
  if (message.action === 'allowDomain') {
    const domain = message.domain;
    if (!allowedDomains.includes(domain)) {
      allowedDomains.push(domain);
      chrome.storage.local.set({ allowedDomains });
    }
    blockedDomains = blockedDomains.filter(d => d !== domain);
    chrome.storage.local.set({ blockedDomains });
    sendResponse({ success: true });
    return true;
  } 
  else if (message.action === 'blockDomain') {
    const domain = message.domain;
    if (!blockedDomains.includes(domain)) {
      blockedDomains.push(domain);
      chrome.storage.local.set({ blockedDomains });
    }
    allowedDomains = allowedDomains.filter(d => d !== domain);
    chrome.storage.local.set({ allowedDomains });
    sendResponse({ success: true });
    return true;
  }
  else if (message.action === 'aiDetected') {
    detectionHistory[message.domain] = {
      tools: message.tools,
      timestamp: Date.now()
    };
    chrome.storage.local.set({ detectionHistory });
    
    chrome.action.setBadgeText({ 
      text: message.tools.length.toString(),
      tabId: sender.tab.id 
    });
    chrome.action.setBadgeBackgroundColor({ 
      color: '#FF5722',
      tabId: sender.tab.id
    });
  }
  else if (message.action === 'getSettings') {
    chrome.storage.local.get(['blockedDomains', 'allowedDomains', 'detectionHistory', 'behaviorDetectionEnabled'], (result) => {
      sendResponse({ 
        blockedDomains: result.blockedDomains || [], 
        allowedDomains: result.allowedDomains || [],
        detectionHistory: result.detectionHistory || {},
        behaviorDetectionEnabled: result.behaviorDetectionEnabled !== false
      });
    });
    return true;
  }
  else if (message.action === 'removeDomain') {
    blockedDomains = blockedDomains.filter(d => d !== message.domain);
    allowedDomains = allowedDomains.filter(d => d !== message.domain);
    chrome.storage.local.set({ blockedDomains, allowedDomains });
    sendResponse({ success: true });
  }
  else if (message.action === 'setBehaviorDetection') {
    behaviorDetectionEnabled = message.enabled;
    chrome.storage.local.set({ behaviorDetectionEnabled });
    sendResponse({ success: true });
  }
});
